/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.event;

import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.fedc.FEDCFileDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class CommonServiceEvent
extends ProblemAnalysisEvent {
    private static final String TRACE_MASKT = "XPACSEVT";
    private static final String TRACE_MASKF = "XPACSEVF";
    private static final String TRACE_MASKD = "XPACSEVD";
    private static final boolean UNIT_TEST = false;

    public CommonServiceEvent(Object source) {
        super(source);
        Trace.trace(TRACE_MASKD, "<-> ctor");
    }

    public Object getData() {
        return this.getMetaData().getMeta("MD_DATA_OBJ");
    }

    public void setData(Object data) {
        this.getMetaData().setMeta("MD_DATA_OBJ", data);
    }

    public PASystem getSystem() {
        return (PASystem)this.getMetaData().getMeta("MD_SYSTEM_OBJ");
    }

    public void setSystem(PASystem system) {
        this.getMetaData().setMeta("MD_SYSTEM_OBJ", system);
    }

    public List getAssociatedFileList() {
        Log log;
        LogBlock dfBlock;
        ArrayList<FEDCFileDescriptor> fileList = new ArrayList<FEDCFileDescriptor>();
        if (this.getData() instanceof Log && (dfBlock = (log = (Log)this.getData()).getLogBlock((byte)-33)) != null) {
            byte[] byteData = (byte[])dfBlock.getData();
            String data = new String(byteData);
            StringTokenizer st = new StringTokenizer(data);
            while (st.hasMoreTokens()) {
                String element = st.nextToken().trim();
                if (element.equals("")) continue;
                FEDCFileDescriptor fd = new FEDCFileDescriptor();
                fd.name = element;
                fd.priority = "high";
                fd.wait = false;
                fd.type = element.startsWith("$") ? "secondary" : "primary";
                fileList.add(fd);
            }
        }
        return fileList;
    }

    public static void main(String[] args) {
        HashSet fileSet = new HashSet();
        try {
            Log theLog = null;
            Log[] retrievedLogs = Log.retrieve(new Byte(27), null, null, null, null, null, null, null);
            for (int i = 0; i < retrievedLogs.length; ++i) {
                theLog = retrievedLogs[i];
                if (theLog.getLogBlock((byte)-33) == null) continue;
                CommonServiceEvent event = new CommonServiceEvent(new Object());
                event.setData(theLog);
                Trace.trace(TRACE_MASKD, "the files are");
                List fileList = event.getAssociatedFileList();
                Trace.trace(TRACE_MASKD, "add the files to the set");
                fileSet.addAll(fileList);
                Trace.trace(TRACE_MASKD, "done adding the files");
                for (int j = 0; j < fileList.size(); ++j) {
                    FEDCFileDescriptor element = (FEDCFileDescriptor)fileList.get(j);
                    Trace.trace(TRACE_MASKD, "output element ={" + element + "}");
                }
            }
            Trace.trace(TRACE_MASKD, "the final set is");
            HashMap<String, FEDCFileDescriptor> map = new HashMap<String, FEDCFileDescriptor>();
            Iterator setIt = fileSet.iterator();
            while (setIt.hasNext()) {
                FEDCFileDescriptor element = (FEDCFileDescriptor)setIt.next();
                map.put(element.name, element);
                Trace.trace(TRACE_MASKD, "output set element ={" + element + "}");
            }
            Trace.trace(TRACE_MASKD, "done");
            Collection collection = map.values();
            Iterator collIt = collection.iterator();
            while (collIt.hasNext()) {
                Trace.trace(TRACE_MASKD, "map element ={" + collIt.next() + "}");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "got an exception");
            Trace.trace(TRACE_MASKD, e);
        }
    }
}

